/* PreferencesController.m created by chris on Wed 30-Jun-1999 */

#import "PreferencesController.h"

@implementation PreferencesController

- (void)showPrefs:(id)sender
{
    fontChanged = NO;
    showOffensive = [mainDoc showOffensive];
    [prefsPanel setFloatingPanel: YES];
    [pathField setStringValue: [mainDoc fortuneLocation]];
    [fontField setStringValue: [NSString stringWithFormat:@"%@ %g",
        [[mainDoc fortuneFont] fontName], [[mainDoc fortuneFont] pointSize]]];
    [offensiveCheckBox setState: ((showOffensive == YES) ? NSOnState : NSOffState)];
    [prefsPanel makeKeyAndOrderFront: nil];
}

- (void)savePrefs:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [mainDoc setFortuneLocation: [pathField stringValue]];
    [defaults setObject: [pathField stringValue] forKey: @"FortuneLocation"];
    [defaults setObject: (showOffensive == YES) ? @"YES" : @"NO" forKey: @"ShowOffensiveFortunes"];
    [mainDoc setShowOffensive: (([offensiveCheckBox state] == NSOffState) ? NO : YES)];
    if (fontChanged)
        {
        [defaults setObject: [newFont fontName] forKey: @"FontName"];
        [defaults setFloat: [newFont pointSize] forKey: @"FontSize"];
        [mainDoc setFortuneFont: newFont];
        }
    [[[NSFontManager sharedFontManager] fontPanel: NO] close];
    [prefsPanel close];
    fontChanged = NO;
}

- (void)cancelPrefs:(id)sender
{
    [prefsPanel close];
}

- (void)showOpenPanel:(id)sender
{
    NSOpenPanel *openPanel = [NSOpenPanel openPanel];
    int ret;
    
    [openPanel setAllowsMultipleSelection: NO];
    ret = [openPanel runModalForDirectory: [[NSBundle mainBundle] resourcePath] file: nil types: nil];
    
    if (ret == NSOKButton)
        [pathField setStringValue: [[openPanel filenames] objectAtIndex: 0]];
}

- (void)showFontPanel:(id)sender
{
    [prefsPanel makeFirstResponder: fontField];
    [[NSFontManager sharedFontManager] setSelectedFont: [mainDoc fortuneFont]
                                            isMultiple: NO];
    [[NSFontManager sharedFontManager] orderFrontFontPanel: self];
}

- (void)changeFont:(id)fontManager
{
    [newFont autorelease];
    newFont = [[fontManager convertFont: [fontManager selectedFont]] retain];
    fontChanged = YES;
    [fontField setStringValue: [NSString stringWithFormat:@"%@ %g",
        							[newFont fontName], [newFont pointSize]]];
    [fontField display];
}

- (void)offensiveClicked:(id)sender
{
    showOffensive = (([offensiveCheckBox state] == NSOffState) ? NO : YES);
}

@end
