/* MainDocument.m
 * Chris Saldanha, June 1999 (modified April 2001 for MacOS X 10.0)
 * Class to display fortunes in a simple window.
 * Can copy the fortune into the pasteboard from a menu option.
 * Clicking in the window's content view makes it go away.
 * For MacOS X - now using swanky classes NSTask/NSFileHandle/NSPipe instead of UNIX calls
 */

#import "MainDocument.h"
#import "PreferencesController.h"

@implementation MainDocument

- init
{
    NSUserDefaults *defaults;
    NSString *fontName, *tmp;
    NSBundle *mb;
    float fontSize;

    if (self = [super init])
        {
        mb = [NSBundle mainBundle];
        datfilesLocation = [[mb pathForResource: @"datfiles" ofType: @""] retain];

        defaults = [NSUserDefaults standardUserDefaults];
        fortuneLocation = [[defaults stringForKey: @"FortuneLocation"] retain];
        if ((fortuneLocation == nil) || (![[NSFileManager defaultManager] fileExistsAtPath: fortuneLocation]))
            {
            [self setFortuneLocation: [mb pathForResource: @"fortune" ofType: @""]];
            }

        fontName = [[defaults objectForKey: @"FontName"] retain];
        fontSize = [defaults floatForKey: @"FontSize"];
        if ((fontName == nil) || (fontSize == 0))
            [self setFortuneFont: [NSFont userFixedPitchFontOfSize: 12]];
        else
            [self setFortuneFont: [NSFont fontWithName: fontName size: fontSize]];
        
        tmp = [defaults stringForKey: @"ShowOffensiveFortunes"];
        if ((tmp == nil) || (![tmp isEqualToString: @"YES"]))
            [self setShowOffensive: NO];
        else
            [self setShowOffensive: YES];
        }

    return self;
}

- (void)activateMainWindow:(id)sender
{
    [self loadNewFortuneAndUpdateWindow:nil];
}

- (void) loadNewFortuneAndUpdateWindow:(id)sender
{
    NSPipe *pipe;
    NSFileHandle *fortuneHandle, *errorHandle;
    NSTask *fortuneTask;
    NSData *fortuneData;
    NSArray *arguments;
    int ret;

    [text autorelease];
    text = [[FortuneTextView alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)];
    [text setFont: fortuneFont];
    [text setEditable: NO];
    [text setRichText: NO];
    [text setDrawsBackground: NO];
    [text setMaxSize:(NSSize){1e7, 1e7}];
    [text setHorizontallyResizable: YES];
	[text setVerticallyResizable: YES];
    [[text textContainer] setContainerSize: (NSSize){1e7, 1e7}];
    [[text textContainer] setWidthTracksTextView:NO];

	fortuneTask = [[NSTask alloc] init];
    [fortuneTask setLaunchPath: fortuneLocation];
    if ([self showOffensive])
        arguments = [NSArray arrayWithObjects: @"-a", datfilesLocation, nil];
    else
        arguments = [NSArray arrayWithObject: datfilesLocation];
    [fortuneTask setArguments: arguments];
    
    pipe = [NSPipe pipe];
    fortuneHandle = [pipe fileHandleForReading];
    [fortuneTask setStandardOutput: pipe];
    pipe = [NSPipe pipe];
    errorHandle = [pipe fileHandleForReading];
    [fortuneTask setStandardError: pipe];
    
    ret = 0;
    NS_DURING
        [fortuneTask launch];
    NS_HANDLER
        [text setString: [NSString stringWithFormat: @"Got no fortune from %@.\nUse the preferences panel to chose the location of the fortune program.", fortuneLocation]];
        ret = 1;
    NS_ENDHANDLER
    
    if (ret != 1)
        {
        [fortuneTask waitUntilExit];
        ret = [fortuneTask terminationStatus];
        if (ret != 0)	//failed to get a fortune...
            {
            fortuneData = [errorHandle readDataToEndOfFile];
            [text setString: [NSString stringWithFormat: @"Got an error from fortune:\n%@",
                                    [NSString stringWithCString: [fortuneData bytes] length: [fortuneData length]]]];
            }
        else		//we succeeded in getting a fortune
            {
            fortuneData = [fortuneHandle readDataToEndOfFile];
            [text setString: [NSString stringWithCString: [fortuneData bytes]
                                              	  length: [fortuneData length]]];
            }
        }
    [fortuneTask release];

	[text sizeToFit];
	[mainWindow setContentSize: [text frame].size];
	[mainWindow setContentView: text];
	[mainWindow center];	//Americans don't know how to spel centre
	[mainWindow makeKeyAndOrderFront:self];
}

- (void)copyFortune:(id)sender
{
    [(NSTextView *)[mainWindow contentView] selectAll: nil];
    [(NSTextView *)[mainWindow contentView] copy: nil];
}

- (void)showPrefs:(id)sender
{
    if (!prefsPanel)
        if(![NSBundle loadNibNamed: @"Preferences" owner: self])
            return;
    [prefsController showPrefs: nil];
}

- (void)showInfo:(id)sender
{
    if (!infoPanel)
        if(![NSBundle loadNibNamed: @"Info" owner: self])
            return;
    [infoPanel makeKeyAndOrderFront: nil];
}

- (void)printFortune:(id)sender
{
    [text print: nil];
}

- (void)setFortuneLocation: (NSString *)__value
{
    [fortuneLocation autorelease];
    fortuneLocation = [__value retain];
}

- (NSString *)fortuneLocation
{
    return fortuneLocation;
}

- (void)setFortuneFont: (NSFont *)__value
{
    [fortuneFont autorelease];
    fortuneFont = [__value retain];
}

- (NSFont *)fortuneFont
{
    return fortuneFont;
}

- (BOOL)showOffensive
{
    return showOffensive;
}

- (void)setShowOffensive: (BOOL)value
{
    showOffensive = value;
}

- (void)dealloc
{
    [fortuneLocation release];
    [datfilesLocation release];
    [fortuneFont release];
    [super dealloc];
}

@end
