//
//	MiscAppDefaults.h -- easy access to preferences
//		Written by Steve Hayman Copyright (c) 1994 by Steve Hayman.
//				Version 1.0.  All rights reserved.
//		This notice may not be removed from this source code.
//
//	This object is included in the MiscKit by permission from the author
//	and its use is governed by the MiscKit license, found in the file
//	"LICENSE.rtf" in the MiscKit distribution.  Please refer to that file
//	for a list of all applicable permissions and restrictions.
//	

#import <appkit/appkit.h>

// A category of Application that provides quick access to preferences
// values from anywhere in an app.  You can use this category to
// send messages to NXApp to retrieve default values (and optionally
// convert them to integers or booleans), or to set values.

// All defaults are registered and looked up using an owner of
// [NXApp appName], so you must be careful not to use these methods
// too early (before Application gets fully running.)


@interface Application(MiscAppDefaults) 

- (int) registerDefaults:(const NXDefaultsVector) v;

- (const char *)defaultValue:(const char *)defName;
- (int) defaultIntValue:(const char *)defName;
- (BOOL) defaultBoolValue:(const char *)defName;

- (int)setDefault:(const char *)defName to:(const char *)defValue;
- (int)setDefault:(const char *)defName toInt:(int)defValue;
- (int)setDefault:(const char *)defName toBool:(BOOL)defValue;

// These two are now obsolete and will go away someday:
- (int)setIntDefault:(const char *)defName to:(int)defValue;
- (int)setBoolDefault:(const char *)defName to:(BOOL)defValue;

@end
