/* FortuneApp.m
 * Version 1.0
 * Chris Saldanha, April 1996
 * Class to display fortunes in a simple window.
 * Can copy the fortune into the ASCII pasteboard from a menu option.
 * Clicking in the window's content view makes it go away.
 */

#import "FortuneApp.h" 
#import "MiscAppDefaults.h"
#import "FortuneText.h"

@implementation FortuneApp

- printFortune
{
FILE *myPipe;
NXScreen *myScreen;
NXRect graphicsRect;
NXStream *fortuneStream;
char str[100];
struct stat buf;

/* Make the Text as wide as the screen to start with. */
(const NXScreen *)myScreen = [myWindow screen];
NXSetRect(&graphicsRect, 0.0, 0.0, myScreen->screenBounds.size.width, 10.0);
[myText sizeTo: graphicsRect.size.width : graphicsRect.size.height];

if (stat(programLocation, &buf) == -1)
	{
	sprintf(str, "%s: %s", programLocation, strerror(errno));
	NXRunAlertPanel("Un-Fortunate Error", str, "OK", NULL, NULL);
	[self terminate:nil];
	}	
myPipe = popen(programLocation, "r");
if (myPipe != NULL)
	{
	fortuneStream = NXOpenFile(fileno(myPipe), NX_READONLY);
	[myText readText: fortuneStream];
	NXClose(fortuneStream);
	pclose(myPipe);
	}
else
	NXRunAlertPanel("Un-Fortunate Error", "Could not open pipe!", "OK", NULL, NULL);

[myText sizeToFit];
[myText getFrame: &graphicsRect];
[myWindow sizeWindow: graphicsRect.size.width : graphicsRect.size.height];
[myWindow center];			/* stupid American misspelling :-# */
[myWindow display];

[myWindow setContentView:myText];
[myWindow makeKeyAndOrderFront:nil];
[myText display];
return self;
}

- anotherFortune:sender
{
[myWindow close];
[self printFortune];
return self;
}

- copyFortune: sender
{
Pasteboard *pboard = [Pasteboard new];

[pboard declareTypes: &NXAsciiPboardType num: 1 owner:self];
[pboard writeType: NXAsciiPboardType fromStream: [myText stream]];
return self;
}

- mouseDown:(NXEvent *)theEvent
{
[self terminate: nil];
return self;
}

-init
{
struct stat buf;
int fontSize;
char *fontName;
NXRect graphicsRect;
NXSetRect(&graphicsRect, 0.0, 0.0, 10.0, 10.0);

(const char *)programLocation = [self defaultValue: "FortuneLocation"];
if (programLocation == NULL)
	{
	[self setDefault: "FortuneLocation" to: "/usr/games/fortune"];
	programLocation = calloc(19, sizeof(char));
	strcpy(programLocation, "/usr/games/fortune");
	}
if (stat(programLocation, &buf) == -1)
	{
	NXRunAlertPanel("Un-Fortunate Error", "Fortune program does not exist!", "OK", NULL, NULL);
	}
(const char *)fontName = [self defaultValue: "FontName"];
if (fontName == NULL)
	{
	[self setDefault: "FontName" to: "Courier-Oblique"];
	fontName = calloc(16, sizeof(char));
	strcpy(fontName, "Courier-Oblique");
	}
fontSize = [self defaultIntValue: "FontSize"];
if (fontSize < 1)
	{
	[self setDefault: "FontSize" toInt: 14];
	fontSize = 14;
	}

myWindow = [[Window alloc] 
				initContent: &graphicsRect
				style: NX_TITLEDSTYLE
				backing: NX_BUFFERED
				buttonMask: 0
				defer: NO];
[myWindow setTitle:"Fortune"];
[myWindow setFreeWhenClosed: NO];

myText = [[Text alloc] initFrame: &graphicsRect
						text: ""
						alignment: NX_LEFTALIGNED];
[myText setBackgroundGray: NX_LTGRAY];
[myText setEditable: NO];
[myText setSelectable: NO];
[myText setVertResizable: YES];
[myText setFont: [Font newFont: fontName size: fontSize]];

myMenu = [[Menu alloc] initTitle: "Fortunate"];
[myMenu addItem: "Another Fortune..." 
		action: @selector(anotherFortune:)
		keyEquivalent: 'a'];
[myMenu addItem: "Copy Fortune" 
		action: @selector(copyFortune:)
		keyEquivalent: 'c'];
[myMenu addItem: "Quit" 
		action: @selector(terminate:)
		keyEquivalent: 'q'];
[myMenu sizeToFit];
[NXApp setMainMenu:myMenu];

return self;
}

-terminate:sender
{
[myWindow close];
[myWindow free];
return [super terminate: sender];
}

@end