/* PreferencesController.m created by chris on Wed 30-Jun-1999 */

#import "PreferencesController.h"

@implementation PreferencesController

- (void)showPrefs:(id)sender
{
    fontChanged = NO;
    [prefsPanel setFloatingPanel: YES];
    [pathField setStringValue: [mainDoc fortuneLocation]];
    [fontField setStringValue: [NSString stringWithFormat:@"%@ %g",
        [[mainDoc fortuneFont] fontName], [[mainDoc fortuneFont] pointSize]]];
    [prefsPanel makeKeyAndOrderFront: nil];
}

- (void)savePrefs:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    [mainDoc setFortuneLocation: [pathField stringValue]];
    [defaults setObject: [pathField stringValue] forKey: @"FortuneLocation"];
    if (fontChanged)
        {
        [defaults setObject: [newFont fontName] forKey: @"FontName"];
        [defaults setFloat: [newFont pointSize] forKey: @"FontSize"];
        [mainDoc setFortuneFont: newFont];
        }
    [[[NSFontManager sharedFontManager] fontPanel: NO] close];
    [prefsPanel close];
    fontChanged = NO;
}

- (void)cancelPrefs:(id)sender
{
    [prefsPanel close];
}

- (void)showFontPanel:(id)sender
{
    [prefsPanel makeFirstResponder: prefsPanel];
    [[NSFontManager sharedFontManager] setSelectedFont: [mainDoc fortuneFont]
                                            isMultiple: NO];
    [[NSFontManager sharedFontManager] orderFrontFontPanel: self];
}

- (void)changeFont:(id)fontManager
{
    [newFont autorelease];
    newFont = [[fontManager convertFont: [fontManager selectedFont]] retain];
    fontChanged = YES;
    [fontField setStringValue: [NSString stringWithFormat:@"%@ %g",
        							[newFont fontName], [newFont pointSize]]];
    [fontField display];
}

@end
