/* MainDocument.m
 * Chris Saldanha, June 1999
 * Class to display fortunes in a simple window.
 * Can copy the fortune into the pasteboard from a menu option.
 * Clicking in the window's content view makes it go away.
 */

#import "MainDocument.h"
#import "PreferencesController.h"

@implementation MainDocument

- init
{
    NSUserDefaults *defaults;
    NSString *fontName;
    float fontSize;

    if (self = [super init])
        {
        defaults = [NSUserDefaults standardUserDefaults];
        fortuneLocation = [[defaults stringForKey: @"FortuneLocation"] retain];
        if (fortuneLocation == nil)
            [self setFortuneLocation: [NSString stringWithString: @"/usr/local/bin/fortune"]];

        fontName = [[defaults objectForKey: @"FontName"] retain];
        fontSize = [defaults floatForKey: @"FontSize"];
        if ((fontName == nil) || (fontSize == 0))
            [self setFortuneFont: [NSFont userFixedPitchFontOfSize: 12]];
        else
            [self setFortuneFont: [NSFont fontWithName: fontName size: fontSize]];
        }

    return self;
}

- (void)activateMainWindow:(id)sender
{
    [self loadNewFortuneAndUpdateWindow:nil];
}

- (void) loadNewFortuneAndUpdateWindow:(id)sender
{
    FILE *myPipe;
    NSFileHandle *fortuneHandle;
    NSData *fortuneData;

    [text autorelease];
    text = [[FortuneTextView alloc] initWithFrame: NSMakeRect(0, 0, 10, 10)];
    [text setFont: fortuneFont];
    [text setEditable: NO];
    [text setRichText: NO];
    [text setDrawsBackground: NO];
    [text setMaxSize:(NSSize){1e7, 1e7}];
    [text setHorizontallyResizable: YES];
	[text setVerticallyResizable: YES];
    [[text textContainer] setContainerSize: (NSSize){1e7, 1e7}];
    [[text textContainer] setWidthTracksTextView:NO];

    myPipe = popen([fortuneLocation lossyCString], "r");
    if (myPipe != NULL)
        {
        fortuneHandle = [[NSFileHandle alloc] initWithFileDescriptor: fileno(myPipe)];
        fortuneData = [fortuneHandle readDataToEndOfFile];
        [fortuneHandle release];
        if ((pclose(myPipe) != 0) || ([fortuneData length] < 1))
            [text setString: [NSString stringWithFormat: @"Got no fortune from %@.\nUse the preferences panel to chose the location of the fortune program.", fortuneLocation]];
        else
        	[text setString: [NSString stringWithCString: [fortuneData bytes]
                                              	  length: [fortuneData length]]];
        [text sizeToFit];
        [mainWindow setContentSize: [text frame].size];
        [mainWindow setContentView: text];
        [mainWindow center];	//Americans don't know how to spel centre
        [mainWindow makeKeyAndOrderFront:self];
        }
    else
        {
        /* this code never seems to run since popen never returns a null file pointer
		   this violates what the manpage says, but hey, what can you do? */
        NSString *tmp = [NSString stringWithFormat: @"Could not open pipe to %@.\nUse the preferences panel to chose the location of the fortune program.", fortuneLocation];
        NSRunAlertPanel(@"Un-Fortunate Error", tmp, @"OK", nil, nil);
        }    
}

- (void)copyFortune:(id)sender
{
    [(NSTextView *)[mainWindow contentView] selectAll: nil];
    [(NSTextView *)[mainWindow contentView] copy: nil];
}

- (void)showPrefs:(id)sender
{
    if (!prefsPanel)
        if(![NSBundle loadNibNamed: @"Preferences" owner: self])
            return;
    [prefsController showPrefs: nil];
}

- (void)showInfo:(id)sender
{
    if (!infoPanel)
        if(![NSBundle loadNibNamed: @"Info" owner: self])
            return;
    [infoPanel makeKeyAndOrderFront: nil];
}

- (void)setFortuneLocation: (NSString *)__value
{
    [fortuneLocation autorelease];
    fortuneLocation = [__value retain];
}

- (NSString *)fortuneLocation
{
    return fortuneLocation;
}

- (void)setFortuneFont: (NSFont *)__value
{
    [fortuneFont autorelease];
    fortuneFont = [__value retain];
}

- (NSFont *)fortuneFont
{
    return fortuneFont;
}

- (void)dealloc
{
    [fortuneLocation release];
    [fortuneFont release];
    [super dealloc];
}

@end
